global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob_6_4Prop")
local handlestate

handlestate = 0

-- engine release lever

global function AnimDone()
	local anim
	local ce3 = FindNodeByName("ce3")
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_Relaase_Lever_Anim_Panel06_Release_Lever_7OC_Idle")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Relaase_Lever_Anim_Panel06_Release_Lever_3OC_Idle")
		ce3:Trigger()
	end

	prop:PlayAnim(anim, 1, 0)
	FindNodeByTag("Ob6_4Sound"):StopTrigger()
	controls.script.TurnOnInterface()
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_Relaase_Lever_Anim_Panel06_Release_Lever_ClockWise")

	handlestate = 1
		
	FindNodeByTag("Ob6_4Sound"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_Relaase_Lever_Anim_Panel06_Release_Lever_Anti_ClockWise")

	handlestate = 0

	FindNodeByTag("Ob6_4Sound"):Trigger()		
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")
	
	controls.script.TurnOffInterface()
	
	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end

	FindNodeByName("Console6InteractableScript").script.Object4State = handlestate

	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO Console Control Text Modified description to reflectr the plot slightly more, this is used to transfer/inspect power
			doctor::SID_2295:Engine Release Lever: When the engines are fully powered up, this engages the gears and lets them control the TARDIS.
		else
			--VO Console Control Text
			amy::SID_2296:This is the very last thing the Doctor uses before we appear or disappear. I think it's the gear, it seems to trigger the engines.
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim

	if handlestate == 0 then
		anim = FindNodeByShortName("EM_ANIMATOR_Relaase_Lever_Anim_Panel06_Release_Lever_7OC_Idle")
	else
		anim = FindNodeByShortName("EM_ANIMATOR_Relaase_Lever_Anim_Panel06_Release_Lever_Anti_ClockWise")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	FindNodeByTag("Ob6_4Sound"):StopTrigger()
	handlestate = 0
end
